/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bungee.utils;

import java.util.Optional;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.command.ConsoleCommandSender;
import net.skinsrestorer.api.PlayerWrapper;
import net.skinsrestorer.api.interfaces.ISRCommandSender;
import net.skinsrestorer.api.interfaces.ISRProxyPlayer;

public class WrapperBungee {
    public static ISRCommandSender wrapCommandSender(final CommandSender sender) {
        return new ISRCommandSender(){

            @Override
            public void sendMessage(String message) {
                sender.sendMessage(TextComponent.fromLegacyText((String)message));
            }

            @Override
            public String getName() {
                return sender.getName();
            }

            @Override
            public boolean hasPermission(String permission) {
                return sender.hasPermission(permission);
            }

            @Override
            public boolean isConsole() {
                return sender instanceof ConsoleCommandSender;
            }
        };
    }

    public static ISRProxyPlayer wrapPlayer(final ProxiedPlayer player) {
        return new ISRProxyPlayer(){

            @Override
            public Optional<String> getCurrentServer() {
                return Optional.ofNullable(player.getServer()).map(server -> server.getInfo().getName());
            }

            @Override
            public void sendDataToServer(String channel, byte[] data) {
                player.getServer().sendData(channel, data);
            }

            @Override
            public PlayerWrapper getWrapper() {
                return new PlayerWrapper(player);
            }

            @Override
            public String getName() {
                return player.getName();
            }

            @Override
            public void sendMessage(String message) {
                player.sendMessage(TextComponent.fromLegacyText((String)message));
            }

            @Override
            public boolean hasPermission(String permission) {
                return player.hasPermission(permission);
            }
        };
    }
}

